/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (b)(3)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 52.227-7013.           */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 2909                              */
/*                         AUSTIN, TEXAS 78769                           */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1988, 1987, Texas Instruments Incorporated.            */
/*  All rights reserved.                                                 */
/*                                                                       */

#include "Types.r"
#include "SysTypes.r"
#include "kchr.r"
#include "traps.r"

/* These define's are used in the MENU resources to disable specific menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000

resource 'WIND' (128, "Sample Window") {
	{64, 60, 314, 460},
	documentProc, visible, noGoAway, 0x0, "Sample Window"
};


/*-------------------------------------SIZE---------------------------------------------*/
type 'SIZE' {
		boolean 				dontSaveScreen, 				/* Save screen			*/
								saveScreen;
		boolean 				ignoreSuspendResumeEvents,		/* suspend-resume		*/
								acceptSuspendResumeEvents;
		boolean					enableOptionSwitch,				/* option-key switching */
								disableOptionSwitch;
		boolean					cannotBackground,				/* accept Juggler bkgd */
								canBackground;
		boolean					notJugglerAware,
								JugglerAware;					/* follows Juggler's rules */
		boolean                 notBackgroundOnly,
		                        BackgroundOnly;
								
		unsigned bitstring[10] = 0; 							/* reserved 			*/
		unsigned longint;										/* size  - 32k 			*/
		unsigned longint;										/* min size - 32k		*/
};

resource 'SIZE' (-1) {
		dontSaveScreen, 				/* Save screen			*/
		acceptSuspendResumeEvents,		/* suspend-resume		*/
		enableOptionSwitch,				/* Options switch		*/
		canBackground,					/* accept Juggler background	*/
		JugglerAware,					/* Juggler aware		*/
		notBackgroundOnly,
		1024000,						/* size 				*/
		563200							/* min size      		*/
};


resource 'DLOG' (128, "About microExplorer") {
	{66, 102, 300, 400},							/* ab 11/7/88 */
	dBoxProc, visible, noGoAway, 0x0,128, ""
};

resource 'DITL' (128, purgeable) {
	{	/* array DITLarray: 9 elements */
		/* [1] */
		{188, 110, 208, 189},
		Button {
			enabled,
			"Continue"
		},
		/* [2] */
		{75, 167, 91, 259},
		StaticText {
			disabled,
			""
		},
		/* [3] */
		{8, 26, 26, 274},
		StaticText {
			disabled,
			"microExplorer for the Macintosh II"
		},
		/* [4] */
		{32, 80, 50, 212},
		StaticText {
			disabled,
			"------------------"
		},
		/* [5] */
		{141, 23, 159, 275},
		StaticText {
			disabled,
			"Copyright  1988 Texas Instruments."
		},
		/* [6] */
		{75, 65, 90, 166},
		StaticText {
			disabled,
			"Creation Date:"
		},
		/* [7] */
		{102, 131, 131, 163},
		Icon {
			disabled,
			128
		},
		/* [8] */
		{160, 79, 176, 217},
		StaticText {
			disabled,
			"All Rights Reserved."
		},
		/* [9] */
		{50, 101, 67, 246},           /* ab 11/7/88 */
		StaticText {
			disabled,
			"Version 2.108"
		}
	}
};

/* ab 11/7/88 */
resource 'DLOG' (180, "Quit microExplorer") {
	{50, 50, 210, 295},							
	dBoxProc, visible, noGoAway, 0x0, 180, "" 
};

/* ab 11/7/88 */
resource 'DITL' (180, purgeable) {
	{
		/* [1] */
		{0x85, 0x84, 0x99, 0xc0},
		Button {
			enabled,
			"OK"
		}, 
		/* [2] */
		{0x84, 0x28, 0x98, 0x64},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{0x0A, 0x51, 0x3C, 0xE4},
		StaticText {
			disabled,
			"Quitting will discard the microExplorer environment."
		},
		/* [4] */
		{0x53, 0x1D, 0x77, 0xCF},
		StaticText {
			disabled,
			"Do you really want to quit microExplorer?"
		},
		/* [5] */
		{0x10, 0x13, 0x37, 0x3E},
		Icon {					/* The open hand icon */
			disabled,
			0
		}
	}
};


	/* TI Bug icon for About microExplorer */
resource 'ICON' (128) {
		$"0000 0000 007F 0000 007F 0000 007F 0000"
		$"007F 0000 007F 0000 007F 0C00 007F 1E00"
		$"007F CCF0 007F C1F8 007F DDF8 007F DDF8"
		$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE"
		$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE"
		$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0"
		$"0003 FF80 0001 FF00 0001 FE00 0000 FE00"
		$"0000 7E00 0000 3F00 0000 0F"
} ;


resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About microExplorer",
			noicon, nokey, nomark, plain;
		"-", 
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, "File",
	{
		"Printer Setup",                        /* ab 11/15/88 */
			noicon, noKey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Quit microExplorer",
			noicon, noKey, nomark, plain
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	AllItems & ~(MenuItem1 | MenuItem2),	/* Disable items #1 & #2 */
	enabled, "Edit",
	 {
		"Undo",
			noicon, noKey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, noKey, nomark, plain;
		"Copy",
			noicon, nokey, nomark, plain;
		"Paste",
			noicon, nokey, nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};


resource 'MENU' (133, "Special", preload) {
	133, textMenuProc,
	allEnabled, 
	enabled, "Special",
	 {
		"Warm Boot",
			noicon, nokey, nomark, plain;
		"Force Crash",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (134, "Options", preload) {
	134, textMenuProc,
	AllItems & ~MenuItem3,	/* Disable item #3 */
    enabled, "Options",
	{
		"Set Boot",
			noicon, nokey, nomark, plain;
		"Set Screen Size",
			noicon, nokey, nomark, plain;
		"-",								/* ab 11/7/88 */
			noicon, nokey, nomark, plain;
		"Enable Direct Drawing",
			noicon, nokey, check, plain;
		"Enable Debug Trace",
			noicon, nokey, nomark, plain
	}
};

/* ab 11/7/88 */
type 'vers' {
	byte;				/* first part of version number in BCD */
	byte;				/* second and third parts of version number in BCD */
	byte development=0x20, alpha=0x40, beta=0x60, release=0x80;
	byte;				/* stage of non-release version */
	integer Country;	/* country code as in international utilities */
	pstring;			/* short version number */
	pstring;			/* long version message */
};
  
/* ab 11/7/88 */ 
resource 'vers' (2) {
	0x02, 0x08, release, 0, verUS,
	"2.108",
	"Driver Version 2.108"
};

type 'TIMX' as 'STR ';		/* ab 11/7/88 */

resource 'TIMX' (0) {						/* ab 11/7/88 */
	"Texas Instruments microExplorer  " 
	"Driver Version 2.108              "
};

#ifdef TRASH
data 'ICN#' (128) { /* guy with wires comming out of head and better mask*/
	$"0000 0060 0000 0080 0000 0100 0000 0200"
	$"0000 0278 0000 0280 1FFF FF38 0000 0240"
	$"1FFF FF98 0000 0420 1FFF FFD0 0000 0824"
	$"1FFF FFC8 0000 2010 1FFF FFE0 0000 8000"
	$"0000 4000 0000 2000 0000 1000 0000 1000"
	$"0000 0800 0000 0800 0000 1000 0000 1000"
	$"0000 1000 0000 0C00 0000 03E0 0000 0010"
	$"0000 0010 0000 0008 0000 0000 0000 0000"
	$"0000 007C 0000 00FC 0000 01FC 0000 03FC"
	$"0000 03FC 0000 03FC 1FFF FFFC 1FFF FFFC"
	$"1FFF FFFC 1FFF FFFC 1FFF FFFC 1FFF FFFC"
	$"1FFF FFFC 1FFF FFFC 1FFF FFFC 0000 FFFC"
	$"0000 7FFC 0000 3FFC 0000 1FFC 0000 1FFC"
	$"0000 0FFC 0000 0FFC 0000 1FFC 0000 1FFC"
	$"0000 1FFC 0000 0FFC 0000 03FC 0000 001C"
	$"0000 001C 0000 000C 0000 0000 0000 0000"
};
#endif

data 'ICN#' (128) { /* TI Bug ICON....Keith 1/27/88 */
	$"0000 0000 007F 0000 007F 0000 007F 0000" 
	$"007F 0000 007F 0000 007F 0C00 007F 1E00" 
	$"007F CCF0 007F C1F8 007F DDF8 007F DDF8" 
	$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE" 
	$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE" 
	$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0" 
	$"0003 FF80 0001 FF00 0001 FE00 0000 FE00" 
	$"0000 7E00 0000 3F00 0000 0F00 0000 0000" 
	$"00FF 8000 00FF 8000 00FF 8000 00FF 8000" 
	$"00FF 8000 00FF 8C00 00FF 9E00 00FF FFF0" 
	$"00FF EFF8 00FF FFFC 00FF FFFC 00FF FFFC" 
	$"FFFF FFFC FFFE 1CFC FFFF FFFE 7FFF FFFF" 
	$"3FFF FFFF 1FFF FFFF 0FFF BFFF 07FF BFFF" 
	$"07FF FFFF 03E7 8FFE 01C7 83FC 0007 FFF0" 
	$"0007 FFC0 0003 FF80 0003 FF00 0001 FF00" 
	$"0000 FF00 0000 7F80 0000 3F80 0000 0F00" 
};

resource 'BNDL' (128) {
	'TIMX',                  /* ab 11/7/88 */
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'ALRT' (100, purgeable) {
	{100, 120, 186, 392},
	100,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1,
		/* [2] */
		OK, visible, sound1,
		/* [3] */
		OK, visible, sound1,
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (100, purgeable) {
	{
		/* [1] */
		{56, 10, 76, 62},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{8, 72, 88, 270},
		StaticText {
			disabled,
			"^0"
		},
		/* [3] */
		{68, 72, 86, 270},
		StaticText {
			disabled,
			"^1"
		}

	}
};

resource 'STR ' (200) {
	"The microExplorer is not installed."
};

resource 'STR ' (201) {
	"The microExplorer Load partition-file or Microcode partition-file "
	"is Missing.  Boot Failed."
};

resource 'STR ' (202) {   /* unused */
	"The microExplorer failed the power-up test."
};

resource 'STR ' (203) {
	"The microExplorer Microcode partition-file did not load properly."
};

resource 'STR ' (204) {
	"microExplorer application open failed."
};

resource 'STR ' (205) {
	"microExplorer application initialization failed."
};

resource 'STR ' (206) {
	"MultiFinder not found.  The microExplorer requires that "
	"MultiFinder is installed and active before it will boot."
};

resource 'STR ' (207) {
	"Unable to write/read memory on microExplorer board."
};

resource 'STR ' (208) {
	"microExplorer board SelfTestErr ="
};

resource 'STR ' (209) {
 	"Boot of microcode timed out."
};

resource 'STR ' (210) {
 	"Boot of microcode failed."
};

resource 'STR ' (211) {
 	"BitArrayPool allocation failed."
};

resource 'STR ' (212) {
	"Memory allocation failed in TV initializations."
};

resource 'STR ' (213) {
	"Memory allocation failed in Disk initializations."
};

resource 'STR ' (214) {
	"return_acb_fast: Can't find acb queue"
};

resource 'STR ' (215) {
	"Memory allocation failure."
};

resource 'STR ' (216) {
	"microExplorer reset timed out."
};

resource 'STR ' (217) {
	"microExplorer keyboard resource not found."
};

resource 'STR ' (218) {
	"System keyboard resource not restored."
};

resource 'STR ' (219) {
	"SYNC timed out, status ="
};

resource 'STR ' (220) {
	"microExplorer reset error ="
};

resource 'STR ' (221) {
	"Error opening MCR file ="
};

resource 'STR ' (222) {
	"Error reading MCR file ="
};

resource 'STR ' (223) {
	"Start address looks bad ="
};

resource 'STR ' (224) {
	"Error on PBHOpen"
};

resource 'STR ' (225) {
	"Error on PBRead"
};

resource 'STR ' (226) {
	"Load Band Write Protected"
};

resource 'STR ' (227) {
	"Error on PBWrite"
};


resource 'ALRT' (128) {
	{28, 138, 208, 378},
	910,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1;
		/* [2] */
		OK, visible, sound1;
		/* [3] */
		OK, visible, sound1;
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 238},
		Button {
			enabled,
			"Continue"
		},
		/* [2] */
		{54, 8, 71, 232},
		StaticText {
			disabled,
			"^0"
		},
		/* [3] */
		{78, 8, 96, 232},
		StaticText {
			disabled,
			"^1"
		}
	}
};

#ifdef TRASH
resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 213},
		Button {
			enabled,
			"Continue"
		};
		/* [2] */
		{49, 11, 66, 207},
		StaticText {
			disabled,
			"^0"
		};
		/* [3] */
		{68, 52, 88, 130},
		StaticText {
			disabled,
			"^1"
		}
	}	
};
#endif

resource 'CURS' (22) {    /* Northwest arrow */
	$"0000 4000 6000 7000 7800 7C00 7E00 7F00"
	$"7800 6C00 4C00 0600 0600 0300 03",
	$"C000 E000 F000 F800 FC00 FE00 FF00 FF80"
	$"FFC0 FC00 FE00 CF00 8F00 0780 0780 0380",
	{1, 0}
};

resource 'CURS' (41) {	/*  Northeast arrow */
	$"0000 0010 0030 0070 00F0 01F0 03F0 07F0"
	$"00F0 01B0 0190 0300 0300 0600 06",
	$"0018 0038 0078 00F8 01F8 03F8 07F8 0FF8"
	$"0FF8 03F8 03F8 0798 0780 0F00 0F00 0E",
	{1, 10}
};

resource 'CURS' (36) {  /* Circle Plus */
	$"0000 0000 0780 1FE0 3B70 3330 6318 7FF8"
	$"7FF8 6318 3330 3B70 1FE0 0780",
	$"0000 0FC0 17A0 3FF0 7B78 F33C E31C FFFC"
	$"FFFC E31C F33C 7B78 3FF0 17A0 0FC0",
	{8, 7}
};

/*   Not used  
resource 'CURS' (100) {	 THin Circle Plus 
	$"0000 0000 07C0 0920 1110 2108 2108 3FF8"
	$"2108 2108 1110 0920 07C0",
	$"0000 07C0 0FE0 1930 3398 638C 6FEC 7FFC"
	$"6FEC 638C 3398 1930 0FE0 07C0",
	{7, 6}
};  not used  */

resource 'CURS' (33) {	/*  Upper left Corner  */
	$"0000 7FE0 7FE0 6000 6000 6000 6000 6000"
	$"6000 6000 60",
	$"FFF0 FFF0 FFF0 FFF0 F000 F000 F000 F000"
	$"F000 F000 F000 F0",
	{2, 1}
};

resource 'CURS' (34) {	/*  Lower Right Corner  */
	$"0000 0000 0030 0030 0030 0030 0030 0030"
	$"0030 0030 1FF0 1FF0",
	$"0000 0078 0078 0078 0078 0078 0078 0078"
	$"0078 3FF8 3FF8 3FF8 3FF8",
	{10, 9}
};

resource 'CURS' (112) {	/* Small Dot */
	$"0000 0000 0000 0000 0000 0300 03",
	$"0000 0000 0000 0000 0380 0780 0780 07",
	{5, 5}
};

resource 'CURS' (78) {	/* Thin hollow plus */
	$"0000 0100 0100 0100 0100 0100 3FF8 0100"
	$"0100 0100 0100 01",
	$"0000 0300 0300 0300 0300 0300 7FF8 7FF8"
	$"0300 0300 0300 0300 03",
	{6, 7}
};


resource 'CURS' (24) {  /* Thick Up Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 07C0 07C0",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 0FE0 0FE0 0FE0 0FE0",
	{1, 7}
};

resource 'CURS' (26) {  /* Thick Down Arrow */
	$"0000 07C0 07C0 07C0 07C0 07C0 07C0 1FF0"
	$"0FE0 07C0 0380 01",
	$"0FE0 0FE0 0FE0 0FE0 0FE0 0FE0 3FF8 3FF8"
	$"1FF0 0FE0 07C0 0380 01",
	{11, 7}
};

resource 'CURS' (113) {  /* Thick Cross */
	$"0000 0000 3006 180C 0C18 0630 0360 01C0"
	$"01C0 0360 0630 0C18 180C 3006",
	$"0000 0000 700E 381C 1C38 0E70 07E0 03C0"
	$"03C0 07E0 0E70 1C38 381C 700E",
	{7, 8}
};

resource 'CURS' (28) {  /* Thick Up-Down Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 1FF0 0FE0 07C0 0380 01",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 3FF8 3FF8 1FF0 0FE0 07C0 0380 01",
	{1, 7}
};

resource 'CURS' (40) {  /* Blank cursor */
	$"",
	$"",
	{2, 7}
};

resource 'DLOG' (160, "Select Screen Size", purgeable) {
	{102, 134, 284, 448},
	rDocProc,
	invisible,
	noGoAway,
	0x0,
	7630,
	"Set Screen Size"
};

resource 'DITL' (7630) {
	{	/* array DITLarray: 14 elements */
		/* [1] */
		{150, 209, 170, 269},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{150, 110, 170, 170},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{89, 7, 105, 55},
		StaticText {
			disabled,
			"Width:"
		},
		/* [4] */
		{89, 128, 105, 184},
		StaticText {
			disabled,
			"Height: "
		},
		/* [5] */
		{89, 56, 105, 116},
		EditText {
			enabled,
			""
		},
		/* [6] */
		{89, 180, 105, 240},
		EditText {
			enabled,
			""
		},
		/* [7] */
		{8, 16, 24, 96},
		RadioButton {
			enabled,
			"640x480"
		},
		/* [8] */
		{32, 16, 48, 104},
		RadioButton {
			enabled,
			"1024x480"
		},
		/* [9] */
		{56, 16, 72, 104},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [10] */
		{8, 160, 24, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [11] */
		{32, 160, 48, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [12] */
		{56, 160, 72, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [13] */
		{119, 7, 136, 273},
		StaticText {
			disabled,
			"Number of Mouse Documentation Lines:"
		},
		/* [14] */
		{119, 273, 135, 304},
		EditText {
			enabled,
			""
		}
	}
};

resource 'DLOG' (150, "Set Boot", purgeable) {
	{112, 108, 340, 560},
	rDocProc,
	visible,
	noGoAway,
	0x0,
	150,
	"Set Boot Parameters"
};

resource 'DITL' (150) {
	{	/* array DITLarray: 17 elements */
		/* [1] */
		{199, 323, 219, 402},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{199, 60, 219, 139},
		Button {
			enabled,
			"Abort"
		},
		/* [3] */
		{16, 8, 34, 104},
		StaticText {
			disabled,
			"Load Volume:"
		},
		/* [4] */
		{16, 103, 32, 443},
		EditText {
			enabled,
			""
		},
		/* [5] */
		{40, 8, 55, 100},
		StaticText {
			disabled,
			"Load Name: "
		},
		/* [6] */
		{88, 8, 102, 103},
		StaticText {
			disabled,
			"MCR Name: "
		},
		/* [7] */
		{64, 8, 80, 104},
		StaticText {
			disabled,
			"MCR Volume: "
		},
		/* [8] */
		{168, 8, 184, 78},
		StaticText {
			disabled,
			"AutoBoot: "
		},
		/* [9] */
		{114, 9, 130, 89},
		StaticText {
			disabled,
			"Host Name: "
		},
		/* [10] */
		{138, 8, 154, 118},
		StaticText {
			disabled,
			"Default Device: "
		},
		/* [11] */
		{40, 104, 56, 443},
		EditText {
			enabled,
			""
		},
		/* [13] */
		{64, 104, 80, 443},
		EditText {
			enabled,
			""
		},
		/* [12] */
		{88, 104, 104, 443},
		EditText {
			enabled,
			""
		},
		/* [15] */
		{113, 96, 130, 266},
		EditText {
			enabled,
			""
		},
		/* [14] */
		{137, 121, 153, 443},
		EditText {
			enabled,
			""
		},
		/* [16] */
		{168, 88, 184, 133},
		RadioButton {
			enabled,
			"Yes"
		},
		/* [17] */
		{168, 152, 185, 197},
		RadioButton {
			enabled,
			"No"
		}
	}
};


/* CPTfont */

data 'FONT' (25600, "CPTfont") {
};

resource 'FONT' (25610, purgeable) {
	0x9000,
	0,
	255,
	255,
	0,
	-2,
	7,
	10,
	0x341,
	8,
	2,
	1,
	57,
	$"D511 D260 0000 164C C6F6 F660 000C 06E6"
	$"EFF6 9E33 1196 E6E6 FCC6 331F F390 3040"
	$"0810 4218 E000 0000 4000 0000 E2CA 015B"
	$"4612 5500 6124 C554 6125 4912 5223 303C"
	$"0003 C800 0000 0032 206F FC02 6600 0024"
	$"0000 0066 010A A000 0027 6E00 4800 8000"
	$"0840 815D 0438 8F80 0000 0000 8060 E000"
	$"4E03 D53B 6A91 0000 29D3 2688 1990 1092"
	$"E999 9889 9433 1BD9 9999 24C6 3311 90A8"
	$"3040 0828 4008 2000 0000 4000 0001 5505"
	$"22A0 0928 2A80 9281 2A28 9282 90A8 3D72"
	$"C875 8C31 7991 3E68 004A 2014 A805 1970"
	$"0680 0120 0099 0095 4F80 004B 7602 0108"
	$"4000 030C EFA7 0C08 88C2 0000 0000 4956"
	$"4700 2E05 DFD7 6A95 4800 2952 2A88 1990"
	$"2043 1999 9889 9435 15D9 9998 24C6 3311"
	$"88C4 3353 2B22 F639 32A6 A5E7 E98C 667D"
	$"5002 5000 0000 0118 0000 0000 0000 0000"
	$"15AA 4335 5249 4A91 5092 C485 4A12 2805"
	$"798B C924 0241 3124 8000 143C 006D 3A42"
	$"011D E44F 0492 ED29 1459 88A4 1CFC D200"
	$"4949 7238 FE00 8550 990B 8800 4B42 CAEE"
	$"269D CF25 79E8 9EE8 F439 11B9 99E6 24C6"
	$"2CA2 8880 18EC DCF5 EA1A 3DD9 DBD8 498C"
	$"6645 5033 4F95 7BBB BBA5 999B 6DA9 9999"
	$"A666 52A2 3795 6DB5 4C0F D0B5 2487 EA31"
	$"2BE4 9989 2B24 024E 3242 40CC D452 006E"
	$"5C05 492A 4820 94B3 8145 248A 8B99 EB03"
	$"322B 2649 4B94 2E04 8539 110B BE3C 4D4C"
	$"3219 E97D C029 5F98 988B 9439 11B9 E991"
	$"24AA 2C4F 8880 03CC 4F24 CA1C 3599 9986"
	$"498C 5A4A 484C C8DB 4444 4462 6665 24B6"
	$"6666 6666 50A7 4F95 ABA4 0002 7CD5 3F48"
	$"8A51 2944 B98B ED27 E4F1 4A42 6B32 B75E"
	$"0000 01F8 C908 9FFF 64AD 0197 CF3C F899"
	$"FF03 33D4 26AE 4A75 EE01 8F96 350D 4800"
	$"8951 3F99 4910 2F49 7999 9889 9535 11B9"
	$"8999 24AA B244 8480 04CC 4C24 CA1E 3199"
	$"9981 498D 5AD2 487F DEDB 7FFF FFE3 FFFD"
	$"24A6 6666 6666 50AA 3B15 69B4 000F D092"
	$"C433 EAD2 2944 D655 0944 544E 4924 81FE"
	$"B451 FF80 0005 5D49 E820 04AD 81E8 E3CE"
	$"88A5 EAFD 2DD7 6999 7256 2E05 8556 E909"
	$"08C3 8951 2299 491D 9081 0999 9889 9533"
	$"1199 8A99 24AB 7248 8480 05CC CCA3 CA19"
	$"3199 9989 5955 6561 504C A8BB 6EEE EEE6"
	$"2221 24A6 6666 6666 4074 8815 5248 0004"
	$"5090 1F00 8D54 A954 0055 364C 0850 8499"
	$"0132 B452 0000 0042 2B88 844F 0312 8001"
	$"A45A 50C2 1C00 0054 9999 43D6 2E00 853A"
	$"D490 00C3 06FE C266 466D 8008 E9E6 EF86"
	$"9ED3 F196 8596 2312 324F 8080 02F3 3B20"
	$"CF99 3196 E786 2722 A47D 504C AF94 9555"
	$"5559 DDDF FFE5 9999 9DDD C027 4815 8C30"
	$"0004 5F60 00FC 882F A954 FFDB C034 0840"
	$"FC66 0132 CFBC 0000 0002 0908 4000 084C"
	$"8002 F8AF 2780 0000 002B 966A 4239 CE00"
	$"0010 0090 00C0 0000 0000 0001 8000 0000"
	$"0000 0000 0000 0000 0000 0000 8080 0000"
	$"0004 8090 0000 8100 0000 0241 5000 6000"
	$"0000 0010 0000 0000 0000 0000 0000 3001"
	$"0000 0000 0000 0000 0800 0008 0000 0000"
	$"0040 0000 0000 0000 0000 0000 4800 0000"
	$"0000 8000 21C2 0000 0000 0000 0000 0200"
	$"0E00 0000 0060 0180 0000 0000 0003 0000"
	$"0000 0000 0000 0000 0000 0000 0000 E383"
	$"C000 0003 0060 0000 8100 0000 0180 E000"
	$"0000 0000 0010 0000 0000 0000 0000 0000"
	$"0002 0000 0000 0000 0000 1000 0000 0000"
	$"0000 0080 0000 0000 0000 0000 0000 3000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0700 0E00 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0001 0004 0009 000E"
	$"0012 0016 0017 001A 001D 0022 0027 002A"
	$"002E 0030 0034 0038 003B 003F 0043 0048"
	$"004C 0050 0054 0058 005C 005E 0061 0064"
	$"0068 006B 006F 0074 0078 007C 0080 0084"
	$"0088 008C 0090 0094 0097 009B 009F 00A3"
	$"00A8 00AC 00B0 00B4 00B8 00BC 00C0 00C5"
	$"00C9 00CE 00D3 00D7 00DC 00E0 00E3 00E6"
	$"00E9 00EE 00F2 00F5 00F9 00FD 0101 0105"
	$"0109 010D 0111 0115 0118 011C 0120 0123"
	$"0128 012C 0130 0134 0138 013C 0140 0144"
	$"0148 014D 0152 0156 015A 015E 0161 0162"
	$"0165 0169 0169 016D 0171 0174 0178 017C"
	$"017F 0182 0186 018A 018E 0192 0196 019A"
	$"019E 01A2 01A6 01AA 01AE 01B1 01B4 01B7"
	$"01BA 01BE 01C2 01C6 01CA 01CE 01D2 01D6"
	$"01DA 01DE 01E2 01E5 01E8 01ED 01F1 01F5"
	$"01F9 01FE 0202 0208 020E 0215 0218 021C"
	$"0221 0227 022D 0233 0238 023B 023E 0243"
	$"0249 024C 0251 0256 025B 0260 0264 0268"
	$"026D 0273 0279 027D 027E 0282 0288 028B"
	$"0290 0296 029C 02A2 02A7 02A7 02AB 02AF"
	$"02B3 02B9 02BF 02C3 02C9 02CE 02D3 02D5"
	$"02D7 02DC 02E1 02E5 02EA 02EF 02F3 02F8"
	$"02FC 0300 0304 030A 0310 0311 0316 0318"
	$"031B 031E 0324 032A 0330 0335 0339 033F"
	$"0342 0347 034B 034F 0353 0357 0359 035D"
	$"0360 0364 0368 036C 0370 0375 037A 037E"
	$"0384 0384 0384 0387 0000 00FF 00FF 00FF"
	$"00FF 00FF 00FF 00FF 00FF 0000 0001 00FF"
	$"00FF 0000 00FF 00FF 00FF 00FF 00FF 00FF"
	$"00FF 00FF 00FF 00FF 00FF 00FF 00FF 00FF"
	$"00FF 00FF 00FF 00FF 0006 0206 0106 0006"
	$"0006 0106 0106 0206 0206 0206 0006 0006"
	$"0106 0106 0206 0106 0106 0106 0106 0106"
	$"0006 0106 0106 0106 0106 0106 0206 0106"
	$"0106 0106 0106 0106 0006 0106 0106 0106"
	$"0106 0106 0106 0106 0106 0206 0106 0106"
	$"0106 0006 0106 0106 0106 0106 0106 0106"
	$"0006 0106 0006 0006 0106 0006 0106 0206"
	$"0106 0206 0006 0106 0206 0106 0106 0106"
	$"0106 0106 0106 0106 0106 0106 0106 0106"
	$"0106 0006 0106 0106 0106 0106 0106 0106"
	$"0106 0106 0006 0006 0106 0106 0106 0106"
	$"0306 0106 0106 0006 0106 0106 0106 0106"
	$"0106 0106 0106 0106 0106 0106 0106 0106"
	$"0106 0106 0106 0106 0106 0106 0106 0106"
	$"0106 0106 0106 0106 0106 0106 0106 0106"
	$"0106 0106 0106 0106 0206 0106 0006 0106"
	$"0106 0106 0006 0106 0006 0006 0007 0106"
	$"0106 0006 0006 0006 0006 0006 0106 0106"
	$"0006 0006 0106 0006 0006 0006 0006 0106"
	$"0106 0006 0006 0006 0106 0306 0106 0006"
	$"0206 0006 0006 0006 0006 0006 0006 0106"
	$"0106 0106 0006 0006 0106 0006 0106 0006"
	$"0306 0106 0006 0006 0106 0006 0006 0106"
	$"0006 0106 0106 0106 0006 0006 0306 0006"
	$"0206 0106 0106 0006 0006 0006 0006 0106"
	$"0006 0206 0006 0106 0106 0106 0106 0206"
	$"0106 0106 0106 0106 0106 0106 0006 0006"
	$"0106 0006 0006 0006 0104 FFFF"
};

resource 'FONT' (25612, purgeable) {
	0x9000,
	0,
	255,
	8,
	0,
	-2,
	8,
	13,
	0x488,
	11,
	2,
	1,
	69,
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 000C 0000 000C 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0E1C 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0006 C000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 CA88 F652 0000 0172 738D F77D"
	$"CE00 001C 0779 DEFF DD1E 18C2 3177 9DE7"
	$"7E31 8C63 F904 80C0 8002 0382 040C 3800"
	$"0000 0040 0000 0009 26EC 8036 CC8F 0CDB"
	$"4801 E09B 1E19 B68F 04DB 4CC2 6D31 0CE0"
	$"3C00 0074 8000 0000 000C 4406 7FF8 04E7"
	$"0000 0120 0000 0019 800C 35A0 0000 0276"
	$"E006 C002 0000 0410 102D E810 788F C000"
	$"0000 0000 2003 0380 0009 C000 018E CA9D"
	$"9952 2000 018E 8C4D 0806 3100 8222 E8C6"
	$"3184 2314 18C3 798C 6318 9231 8C62 1905"
	$"40C0 8002 0402 0004 0800 0000 0040 0000"
	$"0009 2901 4C69 0019 9204 9403 3140 3324"
	$"0919 8A04 9865 03CB 9310 74C7 0E27 9EC4"
	$"FCE8 0012 4401 2290 0A18 BC00 E800 0640"
	$"1026 4006 5ACF C000 04B7 6020 0841 0000"
	$"01C3 9DF2 3830 0888 6083 8000 0000 1114"
	$"B90F 0005 C000 0C55 CFEB 9961 A900 028A"
	$"8C55 0806 3101 0103 18C6 3184 2314 1942"
	$"B98C 6318 1231 8C62 1886 20CE B39A E436"
	$"DC1C 4EAC EB36 CEF4 6318 C7E9 2000 9200"
	$"0000 0000 08E0 0000 0000 0000 0000 0000"
	$"014D 5107 7528 9124 B6C5 2113 6221 2920"
	$"9090 0AF8 C2D9 1120 0481 1049 2000 0012"
	$"1F00 06D3 A420 08EF 909F 0224 5DA4 C850"
	$"B188 5105 4FF3 A200 10A4 45E2 1E1F C000"
	$"0F0A 82A8 2521 7100 029A 0855 EF0A 31DA"
	$"0085 78C6 1184 2114 1E42 B58C 6318 1231"
	$"8A94 2884 0061 CC67 1F4F 240C 8D73 1CCF"
	$"3144 6318 C429 2039 D1F8 B4FB DEF7 BD17"
	$"39CE E739 CB39 CE73 A318 C535 08CF B537"
	$"66A4 E03F 2134 9240 FD20 8897 C918 C225"
	$"3120 089E 2890 9007 38D2 2480 06E5 C054"
	$"4951 2040 8A2A B028 2891 0A88 4A79 300C"
	$"6235 C842 4512 C905 C000 0FDC 829C 4621"
	$"FFC7 C4AA 11A4 18B9 CFDC 7C49 5FFA 11F7"
	$"AFF4 1A42 358F A3E7 1231 8908 F844 000F"
	$"8C23 1446 240D 0D63 18C6 1044 6315 4451"
	$"1046 310C CC84 2108 4308 C631 2108 4CC6"
	$"318C 6318 C505 3D3F 95D5 6880 0009 2154"
	$"9FA1 1123 8492 8918 C2FD 513F 09E0 2920"
	$"4C98 C533 A480 0000 1F8C 4842 7FFF 5229"
	$"2031 3D3A 74FB C47F F00C 63CA 08A3 5913"
	$"297D C000 0089 87CA 8AA1 7100 04CA 207E"
	$"1892 2102 0089 58C6 1184 2314 1942 338C"
	$"2340 922A AA88 4844 0011 8C23 E446 240F"
	$"0D63 18C6 0E44 6352 4489 2046 31EA CCBD"
	$"EF7B DF0F FFFF 2108 48C6 318C 6318 C505"
	$"099F 9536 6880 0009 F954 9212 7D24 8892"
	$"8938 C321 5221 D081 4490 9008 C532 27FF"
	$"F800 0054 4844 2040 222A A03E C285 0A88"
	$"4A79 300C 63CB D514 C5E2 3D85 C000 18C6"
	$"028B 09A1 A900 088A 4445 1892 2101 7D09"
	$"78C6 3184 2315 1942 338C 2B28 922A AC48"
	$"8824 0011 8C23 0446 240C 8C63 18C6 0144"
	$"5555 4D09 207F F30A CCC6 318C 6308 4210"
	$"2108 48C6 318C 6318 C405 5067 1535 6680"
	$"003F 2193 620C 112C 9092 88D7 2521 9421"
	$"509E 4449 200F FD32 2400 0000 0424 EA4F"
	$"909F 0224 5000 058A 9650 5105 4FF4 5C4A"
	$"1518 C502 2985 C000 1184 82AB 3912 2018"
	$"388A 8445 1892 21D8 8201 08C6 3184 2315"
	$"18C2 318C 2518 9224 DC49 0824 0013 8C63"
	$"143E 240C 4C63 18C6 114C 5558 B609 2046"
	$"2D09 CCCE 739C E718 C631 2108 48C6 318C"
	$"6318 C403 9210 1528 9100 0011 2110 0F80"
	$"11D4 A292 A800 2525 E460 20A0 8226 4008"
	$"C532 2480 0000 0023 5C44 0000 01C3 9000"
	$"0A90 AA50 6083 8000 0049 E318 C503 E985"
	$"C000 1D1E 829D 3692 0018 3077 FB84 E711"
	$"CED8 0008 E8F9 DEFC 1D1E E8FE 3174 1B17"
	$"11C4 8C49 F804 000D F39E E406 3F8C 4C62"
	$"EF3E 0E33 C8A8 87E9 2046 29F8 B335 AD6B"
	$"5AE7 39CE FFFF F8B9 CE73 9EF7 BC01 2D10"
	$"15C7 0E00 0011 3EE0 007F 9103 7E92 A9FF"
	$"E6FA 03A0 2080 FE19 8008 C4CF DF00 0000"
	$"0000 4842 0000 0410 1000 17E1 5F27 C000"
	$"0000 0034 22E7 5902 1E79 C000 0000 0008"
	$"000C 0018 0000 0000 0000 0018 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0E1C"
	$"1F00 0000 0044 0088 0000 0804 0000 0000"
	$"4407 C000 1800 0000 0000 0040 0000 0000"
	$"0000 0000 0000 0000 00E0 0100 0000 0000"
	$"0000 0000 0100 0000 1000 0000 0000 0080"
	$"0000 0000 0000 0000 0000 0004 4000 0000"
	$"0000 1000 0083 8200 0000 0000 0000 0000"
	$"0002 0001 C000 0000 0000 0000 0030 0000"
	$"0000 0000 0030 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0038"
	$"0070 0000 0804 0000 0000 3801 0000 0000"
	$"0000 0000 0080 0000 0000 0000 0000 0000"
	$"0000 0000 0200 0000 0000 0000 0000 0200"
	$"0000 0000 0000 0000 0100 0000 0000 0000"
	$"0000 0000 0003 8000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 000F 0001 C000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0001 0005 000A 000F 0014"
	$"0019 001A 001D 0020 0025 002A 002D 0032"
	$"0034 0038 003D 0040 0045 004A 004F 0054"
	$"0059 005E 0063 0068 006A 006D 0071 0076"
	$"007A 007F 0084 0089 008E 0093 0098 009D"
	$"00A2 00A7 00AC 00AF 00B4 00B9 00BE 00C3"
	$"00C8 00CD 00D2 00D7 00DC 00E1 00E6 00EB"
	$"00F0 00F5 00FA 00FF 0104 0107 010B 010E"
	$"0113 0118 011B 0120 0125 012A 012F 0134"
	$"0139 013E 0143 0148 014D 0152 0155 015A"
	$"015F 0164 0169 016E 0173 0178 017D 0182"
	$"0187 018C 0191 0196 019B 019F 01A0 01A4"
	$"01A9 01A9 01AE 01B3 01B7 01BC 01C1 01C5"
	$"01C9 01CE 01D3 01D8 01DD 01E2 01E7 01EC"
	$"01F1 01F6 01FB 0200 0205 020A 020F 0214"
	$"0219 021E 0223 0228 022D 0232 0237 023C"
	$"0241 0246 0249 024D 0252 0257 025C 0261"
	$"0266 026B 0272 0279 0281 0285 028A 028F"
	$"0296 029D 02A4 02A9 02AD 02B1 02B6 02BD"
	$"02C1 02C7 02CD 02D2 02D7 02DC 02E1 02E7"
	$"02EE 02F5 02FA 02FB 0300 0307 030A 0310"
	$"0317 031E 0325 032C 032C 0331 0336 033B"
	$"0342 0349 034E 0355 035A 035F 0361 0363"
	$"0368 036D 0372 0377 037C 0381 0386 038B"
	$"0390 0395 039C 03A3 03A4 03A9 03AB 03AF"
	$"03B3 03BA 03C1 03C8 03CD 03D2 03D9 03DC"
	$"03E3 03E8 03ED 03F2 03F7 03F9 03FE 0402"
	$"0407 040C 0411 0416 041C 0423 0428 042F"
	$"042F 042F 0432 0000 FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF 0000 0001 FFFF FFFF"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 0007 0307 0107 0107 0107"
	$"0107 0107 0207 0207 0207 0107 0107 0107"
	$"0107 0207 0107 0107 0207 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0207 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0207 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0207 0107"
	$"0207 0107 0107 0307 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0207"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0307"
	$"0107 0107 0007 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0207 0107 0107 0107 0107"
	$"0107 0107 0107 0007 0007 0008 0107 0107"
	$"0107 0007 0007 0007 0107 0107 0107 0107"
	$"0007 0107 0007 0007 0107 0107 0107 0107"
	$"0007 0007 0007 0107 0307 0107 0007 0207"
	$"0007 0007 0007 0007 0007 0007 0107 0107"
	$"0107 0007 0007 0107 0007 0107 0107 0307"
	$"0107 0107 0107 0107 0107 0107 0107 0107"
	$"0107 0107 0107 0007 0007 0307 0107 0207"
	$"0107 0107 0007 0007 0007 0107 0107 0007"
	$"0207 0007 0107 0107 0107 0107 0207 0107"
	$"0107 0107 0107 0107 0107 0007 0007 0107"
	$"0007 0007 0007 0104 0107"
};

resource 'FOND' (200, "CPTfont") {
	0x0,
	200,
	0,
	255,
	0,
	0,
	0,
	0,
	0x0,
	0x0,
	0x0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	2,
	{	/* array FontEntries: 2 elements */
		/* [1] */
		12, 0, 25612,
		/* [2] */
		10, 0, 25610,
	},
	$"0000 0000 0006 0000 0000 0000 FC00 1000"
	$"0C00"
};

/* CPTvariable */

resource 'FOND' (190, "CPTvariable") {
	0x0,
	190,
	0,
	255,
	0,
	0,
	0,
	0,
	0x0,
	0x0,
	0x0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	2,
	{	/* array FontEntries: 1 elements */
		/* [1] */
		9, 0, 24329
	},
	$"0000 0000 0006 0000 0000 0000 FC00 1000"
	$"0C00"
};


data 'FONT' (24320, "CPTvariable") {
};

resource 'FONT' (24329, purgeable) {
	0x9001,
	0,
	255,
	7,
	0,
	-2,
	7,
	9,
	0x2FF,
	7,
	2,
	1,
	56,
	$"D511 D260 0000 B266 17B7 B300 00C0 6E6E"
	$"FF69 E331 196E 6E6F 318C C7FC 7206 0801"
	$"0208 4318 0000 0010 0000 0038 B2C0 56D1"
	$"8495 4018 4931 5518 4952 4494 88CC 0F03"
	$"0CF2 0100 0000 C883 7FE0 1330 0001 2000"
	$"0003 3008 5500 0001 3B70 1240 0400 0042"
	$"640A E821 C47C 0000 0000 0401 3700 0270"
	$"D53B 6A91 0001 4E99 3440 CC80 892E 9999"
	$"8899 4331 BD99 9995 318C C464 1506 0801"
	$"0508 0108 0000 0010 0000 0055 4128 A802"
	$"4A0A A024 A04A 8A24 A0A4 2A0F 5CB2 1D64"
	$"925E D13E 6801 2880 A540 28CB 8034 0009"
	$"0184 C804 AA7C 0002 5BB0 1008 4200 0018"
	$"977D 3860 4446 1000 0000 024A CA38 0170"
	$"8FD7 6895 4001 5A11 5740 CCED 0431 9999"
	$"8889 4351 5D99 9985 318C C4A2 1886 6A65"
	$"645A C72C A9A9 69FA 6319 9F54 0CD7 E556"
	$"EEEE 6666 66DB 6066 6669 9995 6A98 CD5B"
	$"6D53 0FD0 92C2 1528 9140 2ACC 7E49 200A"
	$"0989 2406 66A1 E003 69D2 2A48 EF22 7825"
	$"9F6A 48A2 CC45 20E7 E690 1A4A 4B91 C7F0"
	$"8530 990B 9002 6A66 90F7 34EE 7257 FE89"
	$"EEBF 4391 1B9E 9E65 318B 2BE2 1003 1D9B"
	$"9EBD 434F 7676 F612 6319 9154 1332 36D1"
	$"1111 1999 9949 2A99 9999 9994 A995 E56A"
	$"E952 0250 B52A 1FA9 895F 25CC 4979 3E12"
	$"7252 1209 95A2 9003 72E0 4649 5241 04A5"
	$"680C 2924 57DC CF58 199D 6133 725C A170"
	$"8F99 350B B8E2 4A81 FCCA 4B82 0297 9999"
	$"8899 5351 1B98 9915 2AAC 9121 1000 5989"
	$"E499 43CD 6666 6192 6356 B692 1FF7 B6D5"
	$"5555 58FF FF49 2D99 9999 9994 2A8B E55A"
	$"6D00 0FFC D53D 222A 914A 22B4 7F4A 23A7"
	$"8A49 255F F5BA FFFC 000F AAEA 44FF FB25"
	$"680F DF7F F444 CFF8 199E BB4C CBD3 AF70"
	$"0556 E90D 531C 4A89 14CA 48ED 7410 9999"
	$"8899 5331 1998 A995 2ADC 9221 1000 B999"
	$"9479 432C 6666 6256 5559 5854 132A 2EDB"
	$"BBBB B988 8849 2999 9999 9990 1D26 C554"
	$"9200 0450 92C8 CFB6 A54A A002 A9B2 6042"
	$"7424 C809 95A2 9000 0000 115C 4F41 0018"
	$"9400 0D22 D285 2F57 E962 A4CC CA1E B170"
	$"853A D491 031C 37F6 1332 336C 888E 9E6E"
	$"F869 ED3F 1968 5964 C48C 93E0 9000 5E67"
	$"6419 F32C 65B9 E189 C8A9 1F54 132B E525"
	$"5555 5677 77FF F966 6667 7770 09D2 0563"
	$"0C00 045F 601F F221 7D4A A7FE DE01 A042"
	$"87E3 3009 967D E000 0002 1048 4422 7842"
	$"6400 17C5 793E 10E0 0001 5CB3 5211 CE70"
	$"0010 0090 0300 0000 0000 000C 0000 0000"
	$"0000 0000 0000 0000 0000 0020 1000 0000"
	$"0090 1200 0020 4000 0000 9054 0018 0000"
	$"0000 0400 0000 0000 0000 0000 000C 0040"
	$"0000 0000 0000 0020 0000 4000 0000 0002"
	$"0000 0000 0000 0000 0000 0240 0200 0000"
	$"0400 010E 1000 0000 0000 0000 0010 0070"
	$"0000 0060 0600 0000 0000 0018 0000 0000"
	$"0000 0000 0000 0000 0000 0038 7078 0000"
	$"0060 0C00 0020 4000 0000 6038 0000 0000"
	$"0000 0400 0000 0000 0000 0000 0000 0080"
	$"0000 0000 0000 0040 0000 0000 0000 0004"
	$"0000 0000 0000 0000 0000 0180 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0038 0070"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0001 0004 0009 000E 0012 0016"
	$"0017 001A 001D 0022 0025 0028 002B 002D"
	$"0031 0035 0038 003C 0040 0045 0049 004D"
	$"0051 0055 0059 005B 005E 0061 0064 0067"
	$"006B 0070 0074 0078 007C 0080 0084 0088"
	$"008C 0090 0093 0097 009B 009F 00A4 00A8"
	$"00AC 00B0 00B4 00B8 00BC 00BF 00C3 00C8"
	$"00CD 00D1 00D6 00DA 00DD 00E1 00E4 00E9"
	$"00ED 00F0 00F4 00F8 00FC 0100 0104 0108"
	$"010C 0110 0113 0117 011B 011D 0122 0126"
	$"012A 012E 0132 0136 013A 013E 0142 0147"
	$"014C 0150 0154 0158 015B 015C 015F 0163"
	$"0163 0167 016B 016E 0172 0176 0179 017C"
	$"0180 0184 0188 018C 0190 0194 0198 019C"
	$"01A0 01A4 01A8 01AB 01AE 01B1 01B4 01B8"
	$"01BC 01C0 01C4 01C8 01CC 01D0 01D4 01D8"
	$"01DC 01DF 01E2 01E7 01EB 01EF 01F3 01F8"
	$"01FC 0202 0208 020F 0211 0214 0219 021F"
	$"0225 022B 022E 0231 0234 0239 023E 0241"
	$"0246 024B 0250 0255 0259 025D 0262 0268"
	$"026E 0272 0273 0277 027D 0280 0285 028B"
	$"0291 0297 029C 029C 02A0 02A4 02A8 02AE"
	$"02B4 02B8 02BE 02C3 02C8 02CA 02CC 02D1"
	$"02D6 02DA 02DF 02E4 02E8 02ED 02F1 02F5"
	$"02F9 02FF 0305 0306 030B 030D 0310 0313"
	$"0319 031F 0325 032A 032E 0334 0337 033C"
	$"0340 0344 0348 034C 034E 0352 0355 0359"
	$"035D 0361 0365 036A 036F 0373 0379 0379"
	$"0379 037C 0000 FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 0000 0001 FFFF FFFF 0000"
	$"FFFF FFFF FFFF FFFF FFFF 0001 FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF 0004 0103 0105 0006 0006 0005"
	$"0005 0103 0105 0105 0006 0105 0105 0105"
	$"0104 0005 0005 0004 0005 0005 0006 0005"
	$"0005 0005 0005 0005 0104 0105 0004 0105"
	$"0105 0005 0006 0005 0005 0005 0005 0005"
	$"0005 0005 0005 0004 0005 0005 0005 0006"
	$"0005 0005 0005 0005 0005 0005 0004 0005"
	$"0006 0006 0005 0006 0005 0105 0005 0105"
	$"0006 0106 0105 0005 0005 0005 0005 0005"
	$"0005 0005 0005 0004 0005 0005 0003 0006"
	$"0005 0005 0005 0005 0005 0005 0005 0005"
	$"0006 0006 0005 0005 0005 0105 0103 0105"
	$"0106 0004 0005 0005 0004 0005 0005 0004"
	$"0004 0005 0005 0005 0005 0005 0005 0005"
	$"0005 0005 0005 0005 0004 0004 0004 0004"
	$"0005 0005 0005 0005 0005 0005 0005 0005"
	$"0005 0005 0105 0105 0006 0005 0005 0005"
	$"0006 0005 0006 0006 0007 0104 0105 0006"
	$"0006 0006 0006 0105 0105 0105 0006 0006"
	$"0004 0006 0006 0006 0006 0005 0005 0006"
	$"0006 0006 0005 0103 0106 0006 0105 0006"
	$"0006 0006 0006 0006 0006 0005 0005 0005"
	$"0005 0006 0106 0006 0106 0006 0104 0104"
	$"0006 0006 0005 0006 0006 0106 0006 0106"
	$"0106 0106 0006 0006 0103 0006 0104 0105"
	$"0105 0006 0006 0006 0006 0005 0006 0105"
	$"0006 0106 0106 0106 0106 0104 0005 0004"
	$"0005 0005 0005 0005 0006 0006 0005 0006"
	$"0006 0006 0104 FFFF 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0007 0002 0007"
	$"0008 0007 0007 0002 0009 0009 0106 0303"
	$"0504 0401 0502 0007 0007 0007 0007 0007"
	$"0007 0007 0007 0007 0007 0007 0205 0207"
	$"0106 0303 0106 0007 0106 0007 0007 0007"
	$"0007 0007 0007 0007 0007 0007 0007 0007"
	$"0007 0007 0007 0007 0007 0007 0007 0007"
	$"0007 0007 0007 0007 0007 0007 0007 0009"
	$"0007 0009 0003 0801 0004 0205 0007 0205"
	$"0007 0205 0007 0207 0007 0007 0009 0007"
	$"0007 0205 0205 0205 0207 0207 0205 0205"
	$"0007 0205 0205 0205 0205 0207 0205 0009"
	$"0009 0009 0002 0000 0007 0007 0107 0007"
	$"0007 0007 0007 0007 0007 0007 0007 0007"
	$"0007 0207 0007 0007 0007 0007 0007 0007"
	$"0007 0007 0007 0007 0007 0007 0007 0007"
	$"0007 0007 0007 0007 0005 0004 0007 0007"
	$"0008 0204 0007 0108 0007 0007 0004 0102"
	$"0101 0007 0106 0106 0204 0304 0007 0007"
	$"0007 0207 0007 0007 0007 0304 0008 0007"
	$"0007 0106 0205 0105 0007 0007 0302 0106"
	$"0108 0205 0106 0007 0007 0401 0000 0007"
	$"0007 0007 0106 0205 0401 0401 0004 0004"
	$"0004 0004 0205 0007 0009 0106 0106 0008"
	$"0205 0205 0205 0302 0007 0007 0008 0102"
	$"0005 0005 0005 0008 0008 0008 0007 0007"
	$"0106 0303 0205 0204 0204 0204 0204 0302"
	$"0304 0205 0007 0106 0007 0007 0007 0108"
	$"0205 0007 0000 0000 0009 0000"
};

/* MouseFont */

data 'FONT' (25728, "MouseFont") {
};

resource 'FONT' (25744) {
	0x9000,
	0,
	255,
	20,
	0,
	0,
	17,
	16,
	0x637,
	16,
	0,
	0,
	83,
	$"07E1 FFFF FFFF E0F8 01F0 6003 FFE7 0000"
	$"6007 C03E 0000 0000 0070 00E0 7FFF C000"
	$"0800 0008 0000 0000 0000 0018 0060 0003"
	$"0080 0200 0002 0248 0F00 07C0 6000 0180"
	$"3C00 F801 FF00 3FE0 0300 07C0 6000 0180"
	$"3000 F801 FE00 1FE0 0FC0 0F80 0000 0007"
	$"E00F 8007 FC0F F830 0600 0380 1C00 E007"
	$"01FF E000 0007 FFF0 87FF FE00 1800 0040"
	$"0020 0000 0801 0000 1800 0018 0007 F8FF"
	$"F806 2003 0007 FF80 8000 0020 0001 FFFE"
	$"0000 0000 03E1 07E1 FFFF FFFF E3FE 07FC"
	$"7007 FFEC 8000 901F F0FF 8000 0000 00F8"
	$"01F0 4141 E000 1C00 0018 0000 F000 07FF"
	$"F824 00F0 0007 0040 0400 0002 0000 10C0"
	$"7070 7000 0380 C203 8383 E0C0 C1F0 0400"
	$"7070 7000 0380 0803 8383 E300 31F0 0061"
	$"C380 C000 0C0C 000E 1C1F 0330 3E38 0E18"
	$"0FE0 7F03 F81F C300 3000 0007 FFF1 C7FF"
	$"FE00 1810 00E0 0038 0000 0C03 8080 1802"
	$"003C 0007 F880 0806 3003 07FF FF81 8000"
	$"E070 1021 FFFE 1000 0020 0200 07E1 FE00"
	$"3FFF E707 0FFE 380E C06A 4001 0838 39FF"
	$"C000 0000 00D8 01F0 4141 7000 3E70 0038"
	$"0003 F000 07FF F842 01F8 000E 7E20 0838"
	$"7002 0000 0020 17F8 7000 0381 0007 FA03"
	$"F021 03F0 0400 17F8 7000 0380 0807 FA03"
	$"F100 23F0 0020 43C0 E000 1C08 001E 107F"
	$"C1E0 FF9C 1C7E 1FF0 E387 1C38 E4E1 C800"
	$"0000 0803 E7FF FE00 1830 01F0 3C3E 0040"
	$"0C03 4100 1803 007E 0007 F8E0 3806 383B"
	$"782E 0003 8780 E0F8 3031 FFFE 3000 0030"
	$"03FF 07E1 FE00 3FFF EE03 9FFF 1C1C FBE9"
	$"A002 0470 1FFF E000 0000 018C 03F8 4221"
	$"3830 7F70 007F 0007 F888 8E00 1881 03FC"
	$"001C 8110 107F F802 0248 0010 1FF8 5800"
	$"0682 0007 FE07 F812 07F8 0600 1FF8 5800"
	$"0680 1807 FE07 F880 47F8 C010 5FC0 9E01"
	$"E410 061F D07F E0C1 FF8E 38FF 3FF9 80CC"
	$"0660 3433 081C 01C0 1C07 F7FF FE7F 9870"
	$"03F8 FF3F 8070 0E07 2200 1803 80FF 0007"
	$"F878 F006 3C2B 582E 0007 9FE0 E1FC 7039"
	$"FFFE 7000 0038 0001 0700 3E00 3FFF EC01"
	$"9FFF 0E38 FBE4 1004 0220 09FF C1C0 0000"
	$"018C 03F8 4221 1C70 FFF0 00FF C00F 0888"
	$"8E00 1900 87FE 0038 0108 20C7 8C02 0000"
	$"0017 FFFA 7800 0792 0007 FFFD FC12 0FE8"
	$"01C7 FFFA 7800 0790 E007 FFFD FC80 4FE9"
	$"E010 7FE8 FF03 FC50 0F3F F07F F0C3 FF87"
	$"70FF 3FF9 80CC 0662 3400 081C 01C0 3E0F"
	$"FFFF FE3F 18FF FFFD C3BF E07C 070E 1400"
	$"1FFF C1FF 9007 F83D E006 3E1B 682E 000F"
	$"BB70 E3FE FFFD FCFE FFFF FFFC 03FF 2780"
	$"7E00 3FFF F800 FFFF 8770 FBE2 0808 6100"
	$"00FF 83E0 6078 0306 07FC 4411 0EE0 1C70"
	$"007F F00E 0AAA AE00 1A18 4FFF 0070 0104"
	$"40DC EC02 0000 000F 7FFA 7000 0394 0007"
	$"FFBD FC0C 0FE8 0037 7FFA 7000 0393 0007"
	$"FFBD FC8C 4FE9 E71F FFE8 EF03 DC51 CF3F"
	$"FFCF F0C3 FC83 E1FF FFFF 0078 03C2 1C73"
	$"881C 01C0 7F01 C7FF FE1E 19FF F8E1 C3BF"
	$"F87F 039C 0800 1FFF E3FF DC07 F81F C006"
	$"3F33 37EE 001F B330 E071 FFFF FCFF FFFF"
	$"FFFE 0360 7780 7E08 3FEF F820 FFBF 8360"
	$"FBE1 041E F781 0077 0760 E1FE 0326 07BC"
	$"4411 06C0 1C38 1038 F81C 0AAA AE00 1FBD"
	$"FFFF 8060 0202 81F8 7E02 0248 000B FFEB"
	$"F812 07F4 0005 FFF5 FC0C 0FE8 001B FFEB"
	$"F800 07F6 0005 FFF5 FC4C 8FE9 CF9D FFEF"
	$"E601 9FD3 E73F FDCF F0C3 FCC1 C1FF FFFF"
	$"0079 F3CF 9A33 101C 01C0 FF81 C600 1E0C"
	$"1BFF F8E3 66FF FE7F C39C 1400 1FFF F7FF"
	$"FF07 F80F 8000 3FA3 102E 003F E318 E070"
	$"FFFD F87E FFFF FFFC 03E0 FFC0 FE1C 3FC7"
	$"F870 FF1F 8000 FBE0 8203 FC03 8022 0E01"
	$"C7FF 8673 0F1E 4809 0000 1C3C 1818 3C1C"
	$"0FFF FE33 18FF 03FC 0080 0C00 01E0 1FFD"
	$"FC00 0788 DFC8 F80C 07C4 7804 FEC5 FC0C"
	$"0FE8 0788 DFC8 F800 07C4 7804 FEC5 FC73"
	$"8FE9 9FD5 FFA1 F000 3E17 F32F FD0F E0C1"
	$"FC03 E0FF 7FFF 0078 03C2 1E00 181C 01C0"
	$"1C01 C600 1E00 1FFF F8E3 3CFF FFFF F198"
	$"2200 1FFF F8FF 1FC7 F807 003F FC33 302E"
	$"0007 FFF8 E070 7039 F87E 7000 0039 F103"
	$"77E1 FE08 3FEF F820 FFBF 8360 FBE1 C103"
	$"FC01 0014 1C1B 9FFF E623 0FBE 7007 06C0"
	$"381F 1C08 1C38 0FFF FE73 9887 021C 0300"
	$"1002 8060 1802 0000 DFC8 078D FC0C 0FEC"
	$"FEC4 7800 F80C 07C0 DFC8 078D FC73 8FEC"
	$"FEC4 7800 F800 07C2 FFD3 3FA3 F830 7F17"
	$"FEAF E607 C000 F807 70FF 3FF9 80CC 0662"
	$"3580 681C 01C0 1C01 C600 1E00 1FFF F8E3"
	$"3CFF FE7F C198 4100 1FFF F8FF 1F3F FF0F"
	$"803F F61B 602E 000D FFF8 E070 3031 F03E"
	$"3000 0031 1200 27E1 FE00 3FFF F800 FFFF"
	$"8770 FBE2 2087 FE00 0008 181F 07FF 8C01"
	$"9FFF 7007 0EE0 380F FE00 0E38 0AAA AEE1"
	$"D993 824C 0700 1004 4070 3802 024B FFE8"
	$"000D FC0C 0FED FFF4 0003 F812 07F3 FFE8"
	$"001D FC4C 8FED FFF6 0003 F800 07F6 FFF3"
	$"9F33 FC30 FF3F FEE7 CE3F 9806 7F0E 387E"
	$"3FF9 80CC 0660 3461 88FF 8FF8 1C01 C60C"
	$"1E00 1BFF F8E3 66FF F87F 0060 8080 1FFF"
	$"F0FF 1C1F FE1A C000 260F C02E 000C E318"
	$"E070 1021 E01E 1000 0021 1000 07F3 FE00"
	$"3FFF EC01 9FFF 0E38 FBE2 104F FF00 0000"
	$"000E 01FE 0C01 9FFF 4809 1C70 7003 FF00"
	$"0E38 0AAA AFC0 FB99 C264 0E00 1008 203F"
	$"E002 0007 7FF8 000D FC0C 0FEF FFBC 0002"
	$"7000 0397 7FF8 0035 FC8C 4FEF FFBB 0002"
	$"7000 0397 FFF3 CE33 FC30 FF3F FFE3 9E23"
	$"BC0F 711C 1C18 1FF0 E387 1C38 E37F B07F"
	$"07F0 1C01 C61E 1FFF F9FF F8E1 C3BF E07C"
	$"0060 007F FFFF E0FF 100F FC32 603F C303"
	$"002E 0018 3337 FFFE 0001 E01E 0000 0001"
	$"1000 07F3 FE00 3FFF EE03 9FFF 1C1C FBEE"
	$"083F FF80 0000 0000 0078 1800 FFFF C809"
	$"3830 F000 FE00 0FFF 0888 8FC0 FF99 E264"
	$"1C00 1010 100F C002 0007 FFF8 0015 FC12"
	$"0FEF FFFA 0002 7800 0797 FFF8 01C5 FC80"
	$"4FEF FFF8 E002 7800 0790 3FF3 C03F FC30"
	$"FFFF F820 1E23 FC0F F138 0E00 0FE0 7F03"
	$"F81F C112 203E 03E0 1C00 063F 1FFF F8FF"
	$"F8E1 C3BF 8070 07FE 007F FFFF C0FF 0007"
	$"F867 303F C303 002E 0018 3B73 F9FC 0001"
	$"C00E 0000 0001 1000 07FF FE00 3FFF E707"
	$"0FFE 380E FBF1 0403 FC00 0000 0000 0000"
	$"1FFF FFFF C809 700F E000 1C00 0EFE 0888"
	$"8800 0099 0264 3800 0020 0800 0002 0248"
	$"1FF8 0017 F812 07FF FE02 0000 5800 0680"
	$"1FF8 0607 F880 47FF FE00 1800 5800 0680"
	$"2FE1 803F F830 7FEF E820 0C02 7807 9030"
	$"0600 0380 1C00 E007 02D2 D01C 01C0 1C00"
	$"067F 9FFF F870 00E0 FF3E 0040 0492 0000"
	$"0003 80FF 0003 F0CF 987F 8183 0028 0030"
	$"1FE1 F0F8 0001 F87E 0000 0001 13FF 07FF"
	$"FFFF FFFF E3FE 07FC 7007 FBF0 8203 FC00"
	$"0000 0000 0000 1FFF FFFF C809 E00F C000"
	$"1800 007C 0000 0000 0093 024C 7000 1040"
	$"0400 0002 0000 17F8 0023 F021 03F7 FA01"
	$"0000 7000 0380 17F8 0403 F100 23F7 FA00"
	$"0800 7000 0380 21E0 005F F078 3FEF 0810"
	$"0003 8000 7000 0000 0000 0000 0000 0252"
	$"9008 0080 0000 0600 1FFF F830 00E0 3C38"
	$"0000 0492 0000 0003 00FF 0001 E09F C8FF"
	$"0183 01F8 0030 0780 E070 0001 F87E 0000"
	$"0001 1000 07FF FFFF FFFF E0F8 01F0 6003"
	$"FFF0 4103 FC00 0000 0000 0000 0000 0000"
	$"4809 C00F 0000 1000 0038 0000 0000 0087"
	$"021C 6000 0080 0200 0002 0000 7070 10C3"
	$"E0C0 C1F3 8380 C200 7000 0380 7070 0403"
	$"E300 31F3 8380 0800 7000 0380 E1C0 00C7"
	$"C0CC 0F87 0E18 0003 0000 3000 0000 0000"
	$"0000 0000 023F 17FF F000 0000 0600 1FFF"
	$"F810 00E0 0020 0000 050A 0000 0002 00FF"
	$"0000 C0FF F9FE 00C3 0000 0060 0000 4020"
	$"0001 F87E 0000 0001 13FF 07FF F800 0000"
	$"0000 0000 0000 FFE8 2083 FC00 0000 0000"
	$"0000 0000 0000 7FFF 0000 0000 0000 0010"
	$"0000 0000 00FF 03FC 0000 0000 0000 0000"
	$"0000 07C0 0F01 FF00 3FE0 F800 3C00 6000"
	$"0180 07C0 0301 FE00 1FE0 F800 3000 6000"
	$"0180 07C0 1F81 FF03 FE07 C00F C000 0000"
	$"0000 0000 0000 0000 0000 0400 0FFF F000"
	$"0000 0600 1FFF F800 0000 0000 0000 070E"
	$"0000 0000 00FF 0000 0000 07F8 00C3 0000"
	$"0060 0000 0000 0001 F87E 0000 0001 F000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0005 0015 0024 0033 0042 0051 0060"
	$"006B 007B 0089 0096 00A3 00B3 00C3 00D2"
	$"00E1 00F0 00FC 0109 0118 0127 0134 0145"
	$"0155 0163 0171 0180 0188 0197 01A7 01B6"
	$"01BD 01BD 01CD 01DD 01ED 01FD 020D 021D"
	$"022D 023D 024D 025D 026D 027D 028D 029D"
	$"02AD 02BD 02CC 02DB 02EB 02FB 030A 0319"
	$"0329 0339 0339 0339 0339 0339 0339 0339"
	$"0339 033A 0347 0351 035E 036B 0378 0385"
	$"0395 0395 0395 03A4 03AD 03BC 03C5 03D5"
	$"03D5 03D5 03D5 03D5 03D5 03D5 03E5 03E5"
	$"03E5 03E5 03E5 03E5 03E5 03E5 03E5 03E5"
	$"03E5 03E5 03E5 03E5 03E5 03E5 03E5 03E5"
	$"03E5 03E5 03E5 03E5 03E5 03E5 03E5 03E5"
	$"03E5 03E5 03E5 03E5 03E5 03E5 03E5 03E5"
	$"03E5 03E5 03E5 03E5 03E5 03E5 03E5 03E5"
	$"03E5 03F5 03F5 03F5 03F5 03F5 03FE 03FE"
	$"03FE 03FE 03FE 03FE 03FE 03FE 040A 040A"
	$"040A 040A 040A 0419 0424 0424 0424 0424"
	$"0424 0430 0439 0439 0439 0439 0445 0445"
	$"0445 0445 0445 0445 0455 0463 046A 0478"
	$"0478 0478 0485 0485 0485 0485 0485 0492"
	$"049A 049A 04A4 04AD 04B9 04B9 04B9 04B9"
	$"04B9 04B9 04B9 04B9 04B9 04B9 04C1 04C1"
	$"04CD 04CD 04CD 04CD 04CD 04CD 04CD 04CD"
	$"04CD 04CD 04CD 04CD 04CD 04CD 04CD 04CD"
	$"04CD 04D6 04D6 04D6 04D6 04D6 04D6 04DF"
	$"04EF 04EF 04FF 04FF 04FF 04FF 050F 051F"
	$"051F 0524 0010 0010 0010 0010 0010 0010"
	$"FFFF FFFF FFFF 0010 FFFF FFFF FFFF 0010"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0014 0010 0010 0010"
	$"0011 0010 0010 0010 0010 0010 0010 0010"
	$"0010 020B 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0110 0110 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0610 0010 0110 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0310 0010 0310"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0008"
	$"0010 0010 0001 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0010 0010 0010 0010 0010 0010"
	$"0010 0010 0107 FFFF"
};

resource 'FOND' (201, "MouseFont") {
	0x6000,
	201,
	0,
	0,
	0,
	0,
	0,
	0,
	0x0,
	0x0,
	0x0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	2,
	{	/* array FontEntries: 1 elements */
		/* [1] */
		16, 0, 25744
	},
	$"0000 0000 0006 0000 0000 0000 FC00 1000"
	$"0C00"
};

/* BIGfont */

data 'FONT' (25876) {
	$"9000 0000 00FF 00FF 0000 FFFB 000D 0019"        /* .............. */
	$"0C10 0014 0005 0002 0071 0000 0000 0000"        /* .........q...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 3C00 0000 0000 0000 0000"        /* ......<......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 7C03 E000 0000 0000 0000"        /* ......|......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0030 C000 0000 0000 0000 0000"        /* .....0......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0C00 0000 7E00 0000 0000 0000"        /* ........~....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 7C03 E000 0000 0000"        /* ........|....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0069 6000 0000 0000 0000"        /* .......i`....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0006 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0003 8000 0000 0000 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 6000 F192 0C1F 9C0E C300 0000 0000"        /* ..`.......... */
	$"6783 0F0F 00CF F3CF F3C3 C000 0000 0780"        /* g......... */
	$"079F 879F 9FFF E798 7F81 E1E0 61E1 9E7E"        /* ......a.~ */
	$"1E7E 1E7F E1E1 E1E1 E1FF E300 6300 0700"        /* .~..........c... */
	$"3000 00C0 07C0 3006 00F0 3E00 0000 0000"        /* 0...0...>..... */
	$"0000 6000 0000 0000 00C6 30C7 9C60 0019"        /* ..`......0ǜ`.. */
	$"8E3C 606C 079C E623 0000 7800 1CE0 7807"        /* <`l..#..x...x. */
	$"9CE6 2078 079C E620 CC07 9CE6 1C18 1E3C"        /* . x.. .....< */
	$"003F 0000 0000 7ECC 1800 0000 0000 0000"        /* .?....~........ */
	$"00F0 0000 00E3 FFFF E000 63C3 C000 0000"        /* ..........c... */
	$"0018 C000 0000 0000 007F E000 0300 C4C4"        /* ............. */
	$"0000 0000 0004 2EE7 8000 1CE0 0000 3000"        /* .............0. */
	$"0000 0001 8060 0180 19C7 C400 400E 0187"        /* ....`...@.. */
	$"FE00 0000 0000 0000 0000 0000 0003 8007"        /* ............... */
	$"C000 0000 3000 F192 1E3F BE0E C300 0000"        /* ...0...?.... */
	$"0000 6FC7 1F9F 81CF F7EF F7E7 E000 0000"        /* ..o......... */
	$"0FC0 0FDF CFDF DFFF EFD8 7F81 E1E0 73E1"        /* ..........s. */
	$"BF7F 3F7F 3F7F E1E1 E1E1 E1FF E300 6780"        /* .?.?.........g */
	$"0700 3000 00C0 0FC0 3006 00F0 3E00 0000"        /* ..0...0...>... */
	$"0000 0000 6000 0000 0000 00C6 31EF 9C90"        /* ....`......1. */
	$"003B DE3C 60EE 0CDC EF64 8000 FC07 9CE0"        /* .;.<`....d.... */
	$"FC0C DCEF 60FC 0CDC EF61 CE0C DCE6 3E18"        /* ....`....a...>. */
	$"3F7E 007F 0000 0000 7ECC 3000 0000 0000"        /* ?~......~0..... */
	$"0000 0198 6060 01F3 FFFF E000 F7E7 E000"        /* ...``.......... */
	$"0000 0118 C000 0600 0000 0086 1000 0381"        /* ............. */
	$"EDEC 0000 0000 0008 4EEB 8000 1CE0 0000"        /* ........N...... */
	$"1800 0000 0001 8060 0180 3BEC 6C00 C011"        /* ......`.;.l.. */
	$"0187 FE00 0000 0000 0000 0000 0020 0006"        /* ............ .. */
	$"C007 C000 0000 180F F192 3F71 E30F 8186"        /* .......?q.. */
	$"0300 0000 D86F 30F0 C3CC 0C20 3C3C 3000"        /* ....o0.. <<0. */
	$"600C 1867 D878 7878 7818 1878 6601 E360"        /* `..gxxxx..xf..` */
	$"73F1 E1E1 E1E1 E18C 61E1 E1E1 E181 E180"        /* s......a..... */
	$"6CC0 0700 3000 00C0 0C00 3000 0030 0600"        /* l..0....0..0.. */
	$"0000 0000 0000 6000 0000 0000 00C6 3338"        /* ......`......38 */
	$"0091 F0E6 7000 0383 9860 19C4 8003 870C"        /* ...p..`.Ā.. */
	$"C003 8718 6019 C387 1860 19C7 0398 601F"        /* ..`.Ç.`..`. */
	$"E37E 63C3 00FB 670F C0FC 18FC 6738 00FF"        /* .~c..g....g8.. */
	$"E1E6 0000 030C 30C0 0119 8331 8001 B03C"        /* ......0..1.< */
	$"33FC 0001 FB00 0000 0638 0000 0109 0800"        /* 3........8..... */
	$"00E3 3B39 FFC0 0000 0010 8EF3 8C06 0001"        /* ..;9......... */
	$"8060 0C0C 0300 0000 3F03 F1F3 FE30 7403"        /* `......?....0t. */
	$"4021 0386 0780 600F 0000 0000 0000 0030"        /* @!..`........0 */
	$"186C 61F1 81FC 0000 7F00 F1FF EDF1 E30F"        /* .la............ */
	$"81A6 4300 0000 D873 30F0 C6CC 0C00 3C3C"        /* C...s0...<< */
	$"3000 C006 006F F878 7878 7818 1878 6601"        /* 0...o.xxxx..xf. */
	$"E360 6DF1 E1E1 E1E1 E00C 61E1 E1E1 E181"        /* .`m.......a.... */
	$"E180 7860 070F 370F 0ECF 0C0E F73E 01F0"        /* .x`..7.....>.. */
	$"C78D B879 B877 B879 FB0F 0F0F 0F0F FCC6"        /* Ǎywy....... */
	$"3000 0063 1800 0000 0000 0000 0003 0780"        /* 0..c........... */
	$"0018 6000 0000 0000 0000 0000 0000 0000"        /* ..`............. */
	$"001F E3DB 60C0 3CFB 2F9F E1FE 18FC C738"        /* ....`<./....8 */
	$"01FF E3FC 7383 0606 1986 300C C031 8001"        /* ....s...0.1. */
	$"93FC 37FE 39C3 FE18 C000 0C60 0018 0210"        /* .7.9....`.... */
	$"8400 0000 0003 FFCF F000 0021 023F 8C06"        /* .........!.?. */
	$"0001 80F1 FF18 0180 0000 7F8F FDF3 D860"        /* ...........` */
	$"C406 4061 0786 06C0 C03F C3FF C3CC 3000"        /* .@a..?.0. */
	$"0018 0CCC 03F9 F9FC 1FC0 7F0C F1FF ECF1"        /* .............. */
	$"E30D 81B6 C300 0001 9863 30F0 CCCC 0C00"        /* ....c0... */
	$"3C3C 3001 8003 0078 7878 7878 7818 1878"        /* <<0...xxxxxx..x */
	$"6601 E660 6DF9 E1E1 E1E1 E00C 61E1 E1E1"        /* f..`m.......a... */
	$"E181 E0C0 7020 031F BF9F 9FDF 8C1F FFBE"        /* ..p ..... */
	$"01F0 C7CF FCFD FCFF FCFD FB0F 0F0F 0F0F"        /* .............. */
	$"FCC6 3000 0003 1800 0000 0000 0000 0000"        /* .0............. */
	$"0FC0 0000 0000 0000 0000 0000 0000 0000"        /* ............... */
	$"0000 0006 63DB 3060 7EFB 39B0 3303 18CD"        /* ....c.0`~.93.. */
	$"8738 018C 0618 FFC3 0C03 0F06 300C 6031"        /* 8........0.`1 */
	$"8001 97FC 3606 7FE3 0C18 C000 0C60 0018"        /* ..6.......`.. */
	$"0420 4200 0000 0003 181F F800 0039 C45C"        /* . B..........9\ */
	$"800F 0001 81F9 FF30 00CF F800 618E 1DF3"        /* .....0...a.. */
	$"98C3 840C 40CE 0D86 0661 8066 67FF E7EC"        /* Ä.@.afg... */
	$"3000 0F0C 078C 0319 FC30 1FE0 0C00 C012"        /* 0.......0..... */
	$"6C03 3639 819F 8300 0001 98E3 00C0 D8CF"        /* l.69..... */
	$"CDC0 6C3C 3E73 0001 80D9 F878 7818 7818"        /* l<>s....xx.x. */
	$"1818 6601 FE60 6DF9 E1E1 E1E1 E00C 61E1"        /* ..f..`m.......a. */
	$"E1B3 3303 60C0 6000 01F0 F8F0 F1F0 FF31"        /* .3.``........1 */
	$"F9C6 00F1 87B7 C787 8787 C786 630F 0F0F"        /* ...Ǉǆc... */
	$"0F0C 0CC6 3000 F0F3 07FE 19CC 6F8F 8F8F"        /* ...0......o */
	$"8F8F 9C67 8787 879F 1F1F 1F1B 8787 8787"        /* g.... */
	$"8798 7878 7866 3ED8 1838 FF7B 31EF DE79"        /* xxxf>.8.{1..y */
	$"98CF 0000 0D8C 0619 8C63 1801 BFC6 300C"        /* ....c..0. */
	$"3031 9FF1 8C3C 3C03 C633 1C18 C000 1861"        /* 01.<<.3....a */
	$"8C3C 0840 2100 00F0 F073 1831 8C00 0039"        /* <.@!....s.1..9 */
	$"C89D 0019 9861 836C 0C60 006F FE06 619B"        /* ȝ..al.`.o..a */
	$"3780 1980 E418 4181 1986 0633 1F46 2C00"        /* 7...A..3.F,. */
	$"3C3C 3078 DF86 0306 0319 8633 8630 0C0F"        /* <<0x.....30.. */
	$"C012 6C06 1C01 818F 1FE0 FF03 19E3 00C7"        /* .l.......... */
	$"B0CF EFE0 C7EF FE76 1FF0 C19B F87F D818"        /* ....v..... */
	$"7F9F 981F E601 FC60 6DED E1FF 61FF 7E0C"        /* .....`m...a.~. */
	$"61E1 E19E 1E06 6060 6000 0020 F0F0 F0F0"        /* a....```.. .... */
	$"FF30 F0C6 00F3 07B7 8787 8787 8782 630F"        /* .0....c. */
	$"0F0D 9B0C 1886 1001 F9FB 07FE 1BEC 7FDF"        /* ............. */
	$"DFDF DFDF D86F CFCF CFDF 1F1F 1F1F CFCF"        /* ....o..... */
	$"CFCF CFD8 7878 7866 1CD8 187E FF3B 31EF"        /* xxxf..~.;1. */
	$"DEFD 98CC 0000 198C 0639 8C7F F801 BFC6"        /* ......9... */
	$"306C 1831 9FF1 8C3C 3C03 0633 3C18 FFE0"        /* 0l.1.<<..3<... */
	$"1863 583C 1080 1080 01F9 F8FB 1831 8C00"        /* .cX<.......1. */
	$"0039 D11E 7FB0 D861 8666 18FF FFF0 030C"        /* .9..af...... */
	$"6199 E780 1B00 6430 4301 3186 7E1E 1FC6"        /* a...d0C.1~.. */
	$"3C00 3C3C 30FC F806 0303 0331 8637 C631"        /* <.<<0......171 */
	$"ECEC C012 3F0C 1801 81FF FFE0 FF03 1B63"        /* ...?.........c */
	$"0187 B0C0 3E37 E3C7 FE7C 1FF0 631B 7FFF"        /* .>7..|..c... */
	$"D818 7F9F 99FF E601 EC60 61ED E1FE 61FE"        /* ......`a...a. */
	$"3F0C 61E1 E18C 0C3F E060 6000 000F F0F0"        /* ?.a...?.``..... */
	$"30F0 CC30 F0C6 00F6 07B7 8787 8787 8180"        /* 0.0.... */
	$"630F 0F0C F30C 3306 0C03 0F0F 0607 1E3C"        /* c.....3........< */
	$"7070 7070 7070 7818 7878 7863 0303 031C"        /* ppppppx.xxxc.... */
	$"7878 7878 7878 7878 7866 00D8 FFC7 FF1B"        /* xxxxxxxxxf.... */
	$"3F6C DEC1 8000 0007 FF8C 0679 8C7F EC03"        /* ?l......y... */
	$"0606 30FC 0C31 86C1 8C3C 3C03 3FF3 6C18"        /* ..0..1<<.?.l. */
	$"FFE6 3066 3066 2100 0871 8F0F 0D8F 1F31"        /* ..0f0f!..q..1 */
	$"8C00 0000 0000 7FE0 7861 8462 30FF FFFF"        /* .......xab0... */
	$"F998 6198 C600 1E0C 7F61 F611 61FE 7E0C"        /* .a....a..a.~. */
	$"1FFF FC00 3C3C 3ECF B006 0787 83F1 863C"        /* ....<<>ϰ...< */
	$"6633 FCE0 C07F 8D98 3CC1 818F 0300 0006"        /* f3...<.... */
	$"1E63 0300 FFF0 3C31 87E0 3006 0000 C31B"        /* .c....<1.0.... */
	$"7FF8 7818 7818 19F8 6601 E660 61E7 E1E0"        /* ..x.x...f..`a... */
	$"61EC 038C 61E1 ED9E 0C0C 6030 6000 001F"        /* a..a....`0`... */
	$"F0F0 30FF CC30 F0C6 00FE 07B7 8787 8787"        /* ..0.0.... */
	$"80F8 630F 0F6C 630C 6086 1003 0F0F 07E7"        /* .c..lc.`...... */
	$"9E3C 67E7 E7E7 E7E7 F81F FFFF FFE3 0303"        /* <g............. */
	$"0318 7878 7878 7878 7878 7866 00D8 FFC3"        /* ..xxxxxxxxxf.. */
	$"FF1B 3F6F DEC1 8000 0007 FFFF C6D9 8C63"        /* ..?o.......c */
	$"0606 3FC6 318C 1831 86C1 8C3C 3606 7FF3"        /* ..?1.1<6... */
	$"CC30 C06E 3060 0066 1080 10B1 8F0F 0D8F"        /* 0n0`.f... */
	$"1F31 FFFF FFC0 0000 0030 D861 8060 6060"        /* .1......0a``` */
	$"006F F8F0 6199 E600 1FF7 C0C8 0C0E C9FE"        /* .o..a....... */
	$"061E 1FFF FC00 3C3C 3F87 3E06 0CCC C3F9"        /* ......<<?>... */
	$"FC38 7FB6 1CEB C07F 8DB0 67C1 819F 8300"        /* .8....g. */
	$"0006 1C63 0600 FFF0 3C31 8C30 3003 0001"        /* ...c....<100... */
	$"831B 7878 7818 7818 1878 6601 E660 61E7"        /* .xxx.x..xf..`a. */
	$"E1E0 61E6 018C 61B3 6DB3 0C18 6030 6000"        /* ..a..am..`0`. */
	$"0030 F0F0 30FF CC30 F0C6 00FE 07B7 8787"        /* .0..0.0.... */
	$"8787 807C 630F 0F6C F30D F8C6 3003 0F0F"        /* |c..l..0... */
	$"07E6 DE3C 6FEF EFEF EFEF F81F FFFF FFE3"        /* ...<o........... */
	$"0303 0318 7878 7878 7878 7878 7866 00D8"        /* ....xxxxxxxxxf. */
	$"18E3 FF1B 31EF 9EC1 8000 0000 61FF C799"        /* ....1....a.Ǚ */
	$"8C63 030C 3FC6 318C 3031 86C1 8C7C 370E"        /* c..?101|7. */
	$"C603 8C60 C07A 61F8 00C3 0840 2100 030F"        /* .`za...@!... */
	$"0D8F 1831 FFFF FFC0 0000 0019 9871 8860"        /* .1.......q` */
	$"C030 00C0 0060 619B 3600 1FF3 8198 19C1"        /* 0..`a6.... */
	$"9986 0633 1FC6 3C00 3C3C 3F86 3E0F 186C"        /* .3.<.<<?>..l */
	$"C319 F830 7FBC 0CE8 0012 0DE0 6301 81B6"        /* ..0......c. */
	$"C300 000C 1863 0C30 C0CC 3C31 8C30 3001"        /* ....c.0<100. */
	$"9FF3 031B F878 7878 7818 1878 6661 E360"        /* ....xxxx..xfa.` */
	$"61E3 E1E0 6DE6 618C 61B3 6DE1 8C30 6018"        /* a...m.aam.0`. */
	$"6000 0030 F0F0 30F0 0C30 F0C6 00F3 0787"        /* `..0..0..0.... */
	$"8787 8787 8006 630D 9B6D 9B1C C0C6 3003"        /* .cm.0. */
	$"FFFF 1E06 DE3C 7878 7878 7878 7818 1818"        /* .....<xxxxxxx... */
	$"1803 0303 0318 7878 7878 7878 7878 7866"        /* ......xxxxxxxxxf */
	$"00DB 307E 7E1B 31ED DEFD 8000 0007 FF8C"        /* ..0~~.1....... */
	$"0718 FFC3 0198 0606 318C 6031 86C1 87B7"        /* ......1`1 */
	$"E39C C603 0CC0 C072 6061 8CC3 0420 4200"        /* ...r`a. B. */
	$"03FF FD8F 1831 8000 0000 0000 0C0F 1879"        /* ....1........y */
	$"9861 FE18 018F F800 618E 1D80 0000 0328"        /* a.....a....( */
	$"3223 28CC 0661 8046 27FF EC37 E186 3019"        /* 2#(.aF'..7.0. */
	$"9878 6319 8030 663C 0CE8 0012 4DE0 6301"        /* xc.0f<....M.c. */
	$"81A6 4300 000C 1863 1830 C0CC 3C31 8C30"        /* C....c.0<10 */
	$"3000 DFF6 0319 D878 7878 7818 1878 6661"        /* 0.....xxxx..xfa */
	$"E360 61E3 E1E0 6FE3 618C 619E 6DE1 8C60"        /* .`a...o.aam.` */
	$"6018 6000 0030 F0F0 F0F0 0C3F F0C6 00F1"        /* `.`..0.....?... */
	$"8787 8787 8787 8106 630D 9B6F 0FFD 80C6"        /* .co.. */
	$"3003 FFFF 1E06 5E3C 7878 7878 7878 7878"        /* 0.....^<xxxxxxxx */
	$"1818 1803 0303 0318 7878 7878 7878 7878"        /* ........xxxxxxxx */
	$"7866 00DB 301C 3C1B 31EC DE79 8000 0007"        /* xf..0.<.1..y... */
	$"FF8C 0618 739F E0F0 0606 338C C031 86C1"        /* ...s....31 */
	$"83B3 C198 C603 FCC0 C002 C063 5981 8210"        /* ...cY. */
	$"8400 03FF FD8F 1831 8000 0000 0000 0C06"        /* .....1....... */
	$"1FED B061 FE0C 030F F800 7F8F FD80 0000"        /* ..a.......... */
	$"0648 6026 48CC 06C0 C066 63FF CC33 C187"        /* .H`&H.fc.3 */
	$"3819 9878 6319 803F C63C 0CE8 C012 6DE3"        /* 8.xc.?<...m. */
	$"E301 8186 0007 00F8 1863 3030 C0CC 3C31"        /* .......c00<1 */
	$"8C38 3E70 600C 0018 1878 7878 7818 1878"        /* 8>p`....xxxx..x */
	$"6661 E1E0 61E1 E1E0 6363 F18C 619E 73E1"        /* fa..a...cc.as. */
	$"8C60 600C 6000 0030 F0F0 F0F0 CC1F F0C6"        /* ``.`..0...... */
	$"00F0 C787 8787 8787 8186 6F0C F16B 0DEF"        /* ..Ǉo..k. */
	$"00C6 3003 0F0D F606 7E3C 7878 7878 7878"        /* .0....~<xxxxxx */
	$"7FF8 7878 7863 0303 0318 7878 7878 7878"        /* ..xxxc....xxxxxx */
	$"7878 7860 007E 6306 001B 39B0 3303 0000"        /* xxx`.~c...93... */
	$"0001 818C 0618 001F E000 0607 FF8D 8331"        /* ...........1 */
	$"86C9 8000 0198 C637 F8C3 C002 C066 3181"        /* ɀ..7..f1 */
	$"8109 0800 030F 0D8F 1831 8C00 0000 0000"        /* .....1..... */
	$"0006 0F67 E060 C000 0000 0000 3F03 F180"        /* ...g.`.....?.. */
	$"0000 0C88 C04C 8878 0780 603F C000 0000"        /* ...Lx.`?... */
	$"00CF 9FB0 D878 6719 803F 863E 1CE8 C012"        /* .ϟxg.?>... */
	$"3F63 BF80 C300 0007 00F8 0FCF FFDF 80C7"        /* ?c........ */
	$"E7E1 87EF EE70 0000 030F D87F EFDF DFF8"        /* ....p......... */
	$"0FD8 7FBF 61FF E1E1 BF60 3FE1 BF0C 3F0C"        /* ..a...`?..?. */
	$"73E1 8C7F E00C 6000 001F FF9F 9FDF 8C00"        /* s....`...... */
	$"F0FF F0F0 C787 86FD FCFF 80FC 7DFC 61FB"        /* ....Ǉ....}.a. */
	$"0C0F FCC6 3003 0F0C C7FE 3BE7 CFEF EFEF"        /* ...0....;.... */
	$"EFEF EFCF CFCF CFDF FFFF FFF8 6FCF CFCF"        /* ........o */
	$"CFCF EFEF EFE0 0018 FF03 001B 3F1F E1FE"        /* ..........?... */
	$"0000 0003 018F EFF0 0000 1FFF 8607 CCFB"        /* ............. */
	$"FF31 86C9 8FFF F79E 7FEC 007E C003 8060"        /* .1ɏ.....~.` */
	$"03FF C086 1000 030F 0CF9 FFDF F800 0000"        /* .............. */
	$"0000 0000 0063 C060 6000 0000 0001 8060"        /* .....c``.....` */
	$"0180 0000 19FF 8099 FE79 FE00 000F 0000"        /* ......y...... */
	$"0000 00FC CF30 CFCF CFF9 8030 1FE7 F8EE"        /* ....0.0.... */
	$"C012 1E63 9CC0 C300 0007 00E0 078F FFCF"        /* ..c....... */
	$"00C3 C3C1 83C7 CE70 0000 0307 987F C79F"        /* .p.....ǟ */
	$"9FF8 0798 7F9E 61FF E1E1 9E60 1DE1 9E0C"        /* ...a...`... */
	$"1E0C 61E1 8C7F E000 6000 000F 7F0F 0FCF"        /* ..a....`...... */
	$"0C00 F0FF F0F0 C787 8679 F87F 8078 38EC"        /* ......Ǉy..x8. */
	$"619B 0C0F FCC6 3003 0F0C 47FE 19C3 8767"        /* a...0...G..Çg */
	$"6767 6767 6607 8787 879F FFFF FFF8 6787"        /* ggggf.....g */
	$"8787 8787 A7A7 A7A0 0018 DEC3 001B 360F"        /* .....6. */
	$"C0FC 0000 0000 018F FBE0 0000 1FFF 8606"        /* ............. */
	$"0073 FF31 86CD 8FFF F70E 3FC8 003C C003"        /* .s.1͏...?.<. */
	$"8060 03FF C07F E000 030F 0C70 FFCF F000"        /* `........p... */
	$"0000 0000 0000 0061 8060 3000 0000 0001"        /* .......a`0..... */
	$"8060 0180 0000 1009 0110 0831 FE00 0000"        /* `.......1.... */
	$"0000 0000 0078 C060 6787 9CF1 8030 1FC3"        /* .....x`g.0. */
	$"F0E0 0000 0C00 0000 7E00 0007 0000 0000"        /* ........~....... */
	$"0000 0000 0000 0000 0070 0000 0000 0000"        /* .........p...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 7C03 E01F F800 0000"        /* ........|....... */
	$"0000 0030 C000 30C0 0000 0001 8006 0000"        /* ...0.0....... */
	$"0000 0000 030C 006F 6000 0000 C000 0000"        /* .......o`...... */
	$"0000 0000 0000 0200 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 007E 0000"        /* .............~.. */
	$"3000 0000 0000 0000 0000 0000 0000 0000"        /* 0............... */
	$"0006 0000 0000 000F 0000 0000 0000 0000"        /* ................ */
	$"0000 0060 0000 0000 0000 0000 0000 0000"        /* ...`............ */
	$"0000 0000 0000 0000 1860 0000 0000 0000"        /* .........`...... */
	$"0000 0000 0180 0000 0008 0200 0800 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0030"        /* ...............0 */
	$"0000 00E0 0000 0C00 0000 3C00 0006 0000"        /* ..........<..... */
	$"0000 0000 0000 0000 0000 0060 0000 0000"        /* ...........`.... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 7C03 E01F F800"        /* ..........|..... */
	$"0000 0000 003F C000 3FC0 0000 0001 8006"        /* .....?.?..... */
	$"0000 0000 0000 03FC 0036 C000 0003 8000"        /* .........6.... */
	$"0000 0000 0000 0000 0600 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 003C"        /* ...............< */
	$"0000 3000 0000 0000 0000 0000 0000 0000"        /* ..0............. */
	$"0000 000C 0000 0000 0006 0000 0000 0000"        /* ................ */
	$"0000 0000 0060 0000 0000 0000 0000 0000"        /* .....`.......... */
	$"0000 0000 0000 0000 0000 1FE0 0000 0000"        /* ................ */
	$"0000 0000 0000 0180 0000 0008 03E0 0800"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"01FC 0000 00E0 0000 0000 0000 0000 001C"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 01C0 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 001F 8000 1F80 0000 0001"        /* .............. */
	$"8006 0000 0000 0000 01F8 0006 0000 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 1C00 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 6000 0000 0000 0000 0000 0000"        /* ....`........... */
	$"0000 0000 0018 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 01C0 0000 0000 0000 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0FC0 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 01FC 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 C000 0000 0000 0000 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0002 0009 0011 0019 0021 002A 002F 0034"        /* ........!.*...4 */
	$"0039 0043 004B 0050 0058 005B 0063 006B"        /* .9.C.K.P.X.[.c.k */
	$"0072 007A 0082 008C 0094 009C 00A4 00AC"        /* .r.z...... */
	$"00B4 00B7 00BC 00C3 00CC 00D3 00DB 00E3"        /* .......... */
	$"00EB 00F3 00FB 0103 010B 0113 011B 0123"        /* ...............# */
	$"0129 0131 0139 0141 0149 0151 0159 0161"        /* .).1.9.A.I.Q.Y.a */
	$"0169 0171 0179 0181 0189 0191 0199 01A1"        /* .i.q.y..... */
	$"01A9 01B1 01B6 01BE 01C3 01CB 01D5 01DA"        /* ......... */
	$"01E2 01EA 01F2 01FA 0202 020A 0212 021A"        /* ................ */
	$"0222 022A 0232 0237 023F 0247 024F 0257"        /* .".*.2.7.?.G.O.W */
	$"025F 0267 026F 0276 027E 0286 028E 0296"        /* ._.g.o.v.~... */
	$"029E 02A6 02AD 02AF 02B6 02BE 02BE 02C6"        /* ........ */
	$"02CE 02D5 02DD 02E5 02EC 02F3 02FB 0303"        /* .............. */
	$"030B 0313 031B 0323 032B 0333 033B 0343"        /* .......#.+.3.;.C */
	$"034B 0353 035B 0363 036B 0373 037B 0383"        /* .K.S.[.c.k.s.{. */
	$"038B 0393 039B 03A3 03AB 03B3 03BB 03C1"        /* ........ */
	$"03C8 03D0 03D8 03E0 03E8 03F0 03F9 0405"        /* ............. */
	$"0411 041E 0425 042D 0437 0443 044F 045B"        /* .....%.-.7.C.O.[ */
	$"0463 046A 0471 047B 0487 048E 0498 04A3"        /* .c.j.q.{.... */
	$"04AC 04B4 04BC 04C4 04D0 04DC 04E8 04F0"        /* ........... */
	$"04F2 04FB 0507 050D 0516 0522 052E 053A"        /* .........."...: */
	$"0546 0546 054E 0556 055E 056A 0576 057E"        /* .F.F.N.V.^.j.v.~ */
	$"058A 0593 059B 059E 05A1 05A9 05B3 05BB"        /* ........ */
	$"05C5 05CF 05D8 05E2 05EC 05F5 05FF 060B"        /* ............. */
	$"0617 0619 0621 0625 062C 0633 063F 064B"        /* .....!.%.,.3.?.K */
	$"0657 065F 0667 0673 0678 0684 068C 0694"        /* .W._.g.s.x... */
	$"069C 06A4 06A7 06B2 06B9 06C3 06CB 06D3"        /* ........ */
	$"06DD 06E7 06F3 06FC 0708 0708 0708 070B"        /* ................ */
	$"0000 00FF 00FF 00FF 00FF 00FF 00FF 00FF"        /* ................ */
	$"00FF 0000 0002 00FF 00FF 0000 00FF 00FF"        /* ................ */
	$"00FF 00FF 00FF 00FF 00FF 00FF 00FF 00FF"        /* ................ */
	$"00FF 00FF 00FF 00FF 00FF 00FF 00FF 00FF"        /* ................ */
	$"000C 050C 020C 020C 020C 020C 020C 030C"        /* ................ */
	$"030C 030C 010C 020C 020C 020C 030C 020C"        /* ................ */
	$"020C 020C 020C 020C 010C 020C 020C 020C"        /* ................ */
	$"020C 020C 030C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 030C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 030C 020C 030C 020C 010C"        /* ................ */
	$"040C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 030C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 050C 020C 020C 000C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"020C 020C 020C 020C 020C 020C 020C 020C"        /* ................ */
	$"030C 020C 020C 020C 020C 020C 020C 010C"        /* ................ */
	$"000C 000C 000D 030C 020C 010C 000C 000C"        /* ............... */
	$"000C 020C 020C 020C 010C 000C 020C 000C"        /* ................ */
	$"000C 020C 020C 020C 020C 000C 000C 000C"        /* ................ */
	$"020C 050C 010C 000C 030C 010C 000C 000C"        /* ................ */
	$"000C 000C 000C 020C 020C 020C 000C 000C"        /* ................ */
	$"020C 000C 020C 020C 050C 040C 020C 010C"        /* ................ */
	$"020C 010C 010C 020C 010C 010C 010C 010C"        /* ................ */
	$"000C 000C 050C 020C 020C 020C 020C 000C"        /* ................ */
	$"000C 000C 020C 020C 000C 030C 000C 020C"        /* ................ */
	$"020C 020C 020C 030C 010C 020C 010C 020C"        /* ................ */
	$"020C 000C 000C 000C 010C 000C 000C 000C"        /* ................ */
	$"0104 FFFF"                                      /* .... */
};

data 'FONT' (25856, "BIGfont") {
};

data 'FOND' (202, "BIGfont") {
	$"0000 00CA 0000 00FF 0000 0000 0000 0000"        /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"        /* ................ */
	$"0000 0002 0000 0014 0000 6514 0000 0000"        /* ..........e..... */
	$"0006 0000 0000 0000 FC00 1000 0C00"             /* .............. */
};


/* One dummy EADR resource for each slot microExplorer could be in (9-14) */

type 'eadr' { string; };

resource 'eadr' (9) {
	$"FFFF FFFF FFFF"
};

resource 'eadr' (10) {
	$"FFFF FFFF FFFF"
};

resource 'eadr' (11) {
	$"FFFF FFFF FFFF"
};

resource 'eadr' (12) {
	$"FFFF FFFF FFFF"
};

resource 'eadr' (13) {
	$"FFFF FFFF FFFF"
};

resource 'eadr' (14) {
	$"FFFF FFFF FFFF"
};

/* Get the driver assembly lang file. */
include "micronet-device.drvr" 'DRVR' (0:60) AS 'DRVR' ($$ID, $$Name, $$Attributes | 64);
